<?php
    defined('PF_VERSION') OR exit('Access denied');
/**
 * 
 * @package		PageFlex
 * @author		PageFlex Team (vudoanthang83@gmail.com)
 * @copyright	PageFlex Team
 * @link		http://page-flex.com
 * @since		Version 1.0
 * @filesource
 *
 */
class Category_Widget extends Pf_Widget
{

    public $name = 'Post Category';
    public $version = '1.0';
    public $description = 'This is description';

    public function __construct($properties, $setting)
    {
        parent::__construct($properties, $setting);
    }

    public function setting_form()
    {
        require dirname(__FILE__) . '/widget-config.php';
    }

    public function main()
    {
        if (!empty($this->setting['widget-key-category'])) {
            require_once ABSPATH . '/includes/common/plugin/helpers/helper.php';
            require_once ABSPATH . '/includes/common/plugin/utiles/pf-plugin-singleton.php';
            $data = Pf_Plugin_Singleton::categories();
            if (empty($data)) {
                return;
            }
            $nodes = array();
            $list = array();
            foreach ($data as &$node) {
                $node->children = array();
                $id = $node->id;
                $parent_id = $node->category_parent;
                $nodes[$id] = & $node;
                if (array_key_exists($parent_id, $nodes)) {
                    $nodes[$parent_id]->children[] = & $node;
                } else {
                    $list[] = & $node;
                }
            }
            require dirname(__FILE__) . '/widget-show.php';
        }
    }

}
